Ext.data.JsonP.sol_common_as_functions_SendMail({"tagname":"class","name":"sol.common.as.functions.SendMail","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.as.Mail.js","href":"lib_sol.common.as.Mail.html#sol-common-as-functions-SendMail"}],"author":[{"tagname":"author","name":"ELO Digital Office GmbH","email":null}],"version":["1.05.001"],"eloas":true,"requires":["sol.common.Config","sol.common.ObjectFormatter","sol.common.ObjectUtils","sol.common.RepoUtils","sol.common.SordUtils","sol.common.Template","sol.common.UserUtils","sol.common.WfUtils","sol.common.as.FunctionBase","sol.common.as.Mail","sol.common.as.Utils"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.as.FunctionBase","mixins":[],"uses":[],"members":[{"name":"objId","tagname":"cfg","owner":"sol.common.as.FunctionBase","id":"cfg-objId","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.as.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"execute","tagname":"method","owner":"sol.common.as.FunctionBase","id":"method-execute","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.common.as.functions.SendMail","id":"method-initialize","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.as.functions.SendMail","id":"method-process","meta":{}}],"code_type":"ext_define","id":"class-sol.common.as.functions.SendMail","short_doc":"Sends an email\n\nThe SMTP configuration is read from\n  /Administration/Business Solutions Custom/common/Configuration/...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.as.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='docClass'>sol.common.as.FunctionBase</a><div class='subclass '><strong>sol.common.as.functions.SendMail</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Config' rel='sol.common.Config' class='docClass'>sol.common.Config</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectFormatter' rel='sol.common.ObjectFormatter' class='docClass'>sol.common.ObjectFormatter</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.UserUtils' rel='sol.common.UserUtils' class='docClass'>sol.common.UserUtils</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='docClass'>sol.common.as.FunctionBase</a></div><div class='dependency'><a href='#!/api/sol.common.as.Mail' rel='sol.common.as.Mail' class='docClass'>sol.common.as.Mail</a></div><div class='dependency'><a href='#!/api/sol.common.as.Utils' rel='sol.common.as.Utils' class='docClass'>sol.common.as.Utils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.as.Mail.html#sol-common-as-functions-SendMail' target='_blank'>lib_sol.common.as.Mail.js</a></div></pre><div class='doc-contents'><p>Sends an email</p>\n\n<p>The SMTP configuration is read from\n  /Administration/Business Solutions Custom/common/Configuration/mail.config</p>\n\n<h1>SMTP sample configuration:</h1>\n\n<pre><code>{\n   \"smtpHost\": \"smtp.elo.local\"\n}\n</code></pre>\n\n<h1>Usage:</h1>\n\n<pre><code>var sendMail = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.as.functions.SendMail\" rel=\"sol.common.as.functions.SendMail\" class=\"docClass\">sol.common.as.functions.SendMail</a>\", {\n  solutionNameForAsConfig: \"contract\",\n  mode: \"run\",\n  from: \"EloService@elo.local\",\n  to: \"test@elo.local\",\n  cc: \"solutions@elo.com\",\n  bcc: \"solutions@elo.com\",\n  subject: \"Test1\",\n  body: {\n    type: \"html\",\n    tplObjId: \"ARCPATH:/Administration/Business Solutions/contract/Configuration/Mail templates/Notification\",\n  },\n  objId: \"ARCPATH:/Contracts/Test contract\",\n  flowId: \"620\",\n  nodeId: 1,\n  data: { person: { salutation: \"Mr\", firstName: \"Peter\", lastName: \"Smith\" } },\n  atts: [{ objId: \"CURRENT\" },\n         { objId: \"ARCPATH:/Contracts/Test contract/Document1\" },\n         { objId: \"ARCPATH:/Contracts/Test contract/Document1\", convertToPdf: true }],\n  user: \"user1\",\n  password: \"elo\",\n  debug: true\n});\nsendMail.process();\n</code></pre>\n\n<h1>Examples of the property 'to':</h1>\n\n<ul>\n<li><p>\"to\": \"user@domain.com\"\nSend the email to the email adress \"user@domain.com\"</p></li>\n<li><p>\"to\": { type: \"GRP\", key: \"CONTRACT_RESPONSIBLE\" }\nTake the user or email adress from the index field \"CONTRACT_RESPONSIBLE\"</p></li>\n<li><p>\"to\": { type: \"MAP\", key: \"USER\" }\nTake the user or email adress from the map field \"USER\"</p></li>\n<li><p>\"to\": { type: \"WFMAP\", key: \"USER\" }\nTake the user or email adress from the workflow map field \"USER\"</p></li>\n<li><p>\"to\": { type: \"CURRENT\" }\nSend the email to the current node user</p></li>\n<li><p>\"to\": { type: \"NEXT\", key: \"USER\" }\nSend the email to the user of the next person node</p></li>\n<li><p>\"to\": { type: \"WFOWNER\" }\nSend the email to the workflow owner</p></li>\n<li><p>\"to\": { type: \"SORDOWNER\" }\nSend the email to the object owner</p></li>\n</ul>\n\n\n<p>If a field contains a \"@\" char, it's interpreted as an email address, otherwise it is\ninterpreted as an ELO user and the email adress will be retrieved from the user\nprofile.</p>\n\n<h1>Sample ELOas node configuration:</h1>\n\n<pre><code>{\n  \"$directRule\": \"sol.common.as.SendMail\",\n  \"mode\": \"run\",\n  \"from\": \"elo@contelo.com\",\n  \"to\": \"solutions@elo.com\",\n  \"subject\": \"Neue Aufgabe\",\n  \"body\": {\n    \"type\": \"html\",\n    \"tplObjId\": \"ARCPATH:/Administration/Business Solutions Custom/notify/Configuration/Mail templates/Example\",\n    \"data\": {\n      \"person\": {\n        \"salutation\": \"Mr\",\n        \"firstName\": \"Peter\",\n        \"lastName\": \"Smith\"\n      }\n    }\n  }\n}\n</code></pre>\n      <p class='version-tag'>Version: <b>1.05.001</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-objId' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='defined-in docClass'>sol.common.as.FunctionBase</a><br/><a href='source/lib_sol.common.as.FunctionBase.html#sol-common-as-FunctionBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.FunctionBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='defined-in docClass'>sol.common.as.FunctionBase</a><br/><a href='source/lib_sol.common.as.FunctionBase.html#sol-common-as-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-execute' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='defined-in docClass'>sol.common.as.FunctionBase</a><br/><a href='source/lib_sol.common.as.FunctionBase.html#sol-common-as-FunctionBase-method-execute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.FunctionBase-method-execute' class='name expandable'>execute</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Execution of the function module ...</div><div class='long'><p>Execution of the function module</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.SendMail'>sol.common.as.functions.SendMail</span><br/><a href='source/lib_sol.common.as.Mail.html#sol-common-as-functions-SendMail-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.SendMail-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.as.FunctionBase-method-initialize\" rel=\"sol.common.as.FunctionBase-method-initialize\" class=\"docClass\">sol.common.as.FunctionBase.initialize</a></p></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.SendMail'>sol.common.as.functions.SendMail</span><br/><a href='source/lib_sol.common.as.Mail.html#sol-common-as-functions-SendMail-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.SendMail-method-process' class='name expandable'>process</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Sends an email ...</div><div class='long'><p>Sends an email</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.as.FunctionBase-method-process\" rel=\"sol.common.as.FunctionBase-method-process\" class=\"docClass\">sol.common.as.FunctionBase.process</a></p></div></div></div></div></div></div></div>","meta":{"eloas":true}});